<?php
/**
 * 2007-2018 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2018 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 *
 * Don't forget to prefix your containers with your own identifier
 * to avoid any conflicts with others containers.
 */

namespace CleverReach\PrestaShop\Classes\Utility;

class UpdateHelper
{
    public static function getTagsInOldFormat()
    {
        /** @var int $langId */
        $langId = \Context::getContext()->language->id;

        $query = 'SELECT g.`id_group`, gl.`name`
                  FROM `' . _DB_PREFIX_ . 'group` AS g 
                  INNER JOIN `' . _DB_PREFIX_ . 'group_lang` as gl ON gl.`id_group` = g.`id_group`
                  WHERE gl.`id_lang`="'.pSQL($langId).'"
                  GROUP BY gl.`name`';

        /** @var array $groups */
        $groups = \Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        $query = 'SELECT s.`id_shop`, s.`name`
                  FROM `' . _DB_PREFIX_ . 'shop` AS s';

        /** @var array $allShops */
        $allShops = \Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        return array_merge(
            self::formatById($groups, 'PS-G-'),
            self::formatById($allShops, 'PS-S-')
        );
    }

    /**
     * Converts array[] to string[]
     *
     * @param array $dbRows
     * @param string $prefix
     * @return array
     */
    private static function formatById($dbRows, $prefix)
    {
        $results = array();

        foreach ($dbRows as $row) {
            if (isset($row['name'])) {
                $results[] = $prefix . str_replace(' ', '_', $row['name']);
            }
        }

        return $results;
    }
}
