<?php
/**
 * 2007-2018 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2018 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 *
 * Don't forget to prefix your containers with your own identifier
 * to avoid any conflicts with others containers.
 */

use CleverReach\BusinessLogic\Sync\InitialSyncTask;
use CleverReach\Infrastructure\TaskExecution\QueueItem;

require_once 'AdminCleverReachBaseController.php';

class AdminCleverReachInitialSyncController extends AdminCleverReachBaseController
{
    public function initContent()
    {
        parent::initContent();
        $this->initTabModuleList();
        $this->initToolbar();
        $this->initPageHeaderToolbar();
        $this->addToolBarModulesListButton();
        unset($this->toolbar_btn['save']);

        $logoUrl = $this->getModuleFileUrl('views/img/logo_cleverreach.svg');
        $statusCheckUrl = $this->context->link->getAdminLink('AdminCleverReachInitialSync') . '&' .
            http_build_query(array('ajax' => true,'action' => 'getInitialSyncStatus'));
        $dashboardUrl = $this->context->link->getAdminLink('AdminCleverReachDashboard');

        $this->context->smarty->assign(
            array(
                'cleverreach_logoUrl' => $logoUrl,
                'cleverreach_statusCheckUrl' => $statusCheckUrl,
                'cleverreach_dashboardUrl' => $dashboardUrl,
                'cleverreach_recipientSyncTaskTitle' => sprintf(
                    $this->l('Import recipients from %s to CleverReach®'),
                    $this->getConfigService()->getIntegrationName()
                ),
            )
        );

        $this->setTemplate('task_list.tpl');
    }

    public function displayAjaxGetInitialSyncStatus()
    {
        $initialSyncTaskQueueItem = $this->getQueueService()->findLatestByType('InitialSyncTask');
        if ($initialSyncTaskQueueItem === null) {
            die(Tools::jsonEncode(array(
                'status' => QueueItem::FAILED,
            )));
        }

        /** @var InitialSyncTask $initialSyncTask */
        $initialSyncTask = $initialSyncTaskQueueItem->getTask();
        $initialSyncTaskProgress = $initialSyncTask->getProgressByTask();

        die(Tools::jsonEncode(array(
            'status' => $initialSyncTaskQueueItem->getStatus(),
            'statistics' => array(
                'recipients_count' => $initialSyncTask->getSyncedRecipientsCount(),
                'group_name' => $this->getConfigService()->getIntegrationName(),
            ),
            'taskStatuses' => array(
                'subscriberlist' => array(
                    'status' => $this->getStatus($initialSyncTaskProgress['subscriberList']),
                    'progress' => $initialSyncTaskProgress['subscriberList'],
                ),
                'add_fields' => array(
                    'status' => $this->getStatus($initialSyncTaskProgress['fields']),
                    'progress' => $initialSyncTaskProgress['fields'],
                ),
                'recipient_sync' => array(
                    'status' => $this->getStatus($initialSyncTaskProgress['recipients']),
                    'progress' => $initialSyncTaskProgress['recipients'],
                ),
            ),
        )));
    }

    /**
     * @param int $progress
     *
     * @return string
     */
    private function getStatus($progress)
    {
        $status = QueueItem::QUEUED;
        if (0 < $progress && $progress < 100) {
            $status = QueueItem::IN_PROGRESS;
        } elseif ($progress >= 100) {
            $status = QueueItem::COMPLETED;
        }

        return $status;
    }
}
