<?php
/**
 * 2007-2018 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2018 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Updates module from previous versions to the version 2.1.0.
 * Modify database, register a new hooks ...
 */
function upgrade_module_2_1_0()
{
    $initializer = new \CleverReach\PrestaShop\Classes\Initializer();
    $initializer->registerServices();
    $updateSyncTask = new \CleverReach\BusinessLogic\Sync\UpdateTagsToNewSystemTask(
        \CleverReach\PrestaShop\Classes\Utility\UpdateHelper::getTagsInOldFormat()
    );

    \CleverReach\Infrastructure\ServiceRegister::getService(\CleverReach\Infrastructure\TaskExecution\Queue::CLASS_NAME)
        ->enqueue('PrestaShop-update', $updateSyncTask);

    return true;
}
