/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2018 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*
* Don't forget to prefix your containers with your own identifier
* to avoid any conflicts with others containers.
*/

var CleverReach = CleverReach || {};

/**
 * Checks connection status
 */
(function() {

    /**
     * Configurations and constants
     *
     * @type {{get}}
     */
    var config = (function () {
        var constants = {
            CHECK_STATUS_URL: '&ajax=true&action=checkConnectionStatus',
            STATUS_FINISHED: 'finished'
        };

        return {
            get: function (name) {
                return constants[name];
            }
        };
    })();

    function AuthorizationConstructor(authUrl, adminUrl) {
        this.checkConnectionStatus = function (successCallback) {
            var authWin = window.open(authUrl, 'authWindow',
                'toolbar=0, location=0, menubar=0, width=600');

            var winClosed = setInterval(function () {
                if (authWin.closed) {
                    clearInterval(winClosed);
                    getStatus();
                }
            }, 250);

            function getStatus() {
                CleverReach.Ajax.post(adminUrl + config.get('CHECK_STATUS_URL'), null, function (response) {
                    if (response.status === config.get('STATUS_FINISHED')) {
                        successCallback();
                    } else {
                        getStatus();
                    }
                } , 'json', true);
            }
        };
    }

    CleverReach.Authorization = AuthorizationConstructor;
})();

