/**
 * 2007-2018 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2018 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 *
 * Don't forget to prefix your containers with your own identifier
 * to avoid any conflicts with others containers.
 */

var CleverReach = CleverReach || {};

(function () {
    var autoRedirectInterval, startTime, url, period, countdownTemplate;

    function start(redirectUrl, waitPeriod) {
        var countdownEl = document.querySelector('[data-success-panel] [data-success-panel-autoredirect-text]');

        url = redirectUrl;
        period = waitPeriod;
        startTime = new Date();
        countdownTemplate = countdownEl.innerHTML;

        refreshCounter();
        autoRedirectInterval = setInterval(refreshCounter, 250);
        setTimeout(redirect, period);
    }

    function refreshCounter() {
        var elapsedTime = (new Date()).getTime() - startTime.getTime(),
            countdownValue = parseInt((period - elapsedTime) / 1000),
            i, countdownTextEls;

        countdownTextEls = document.querySelectorAll('[data-success-panel] [data-success-panel-autoredirect-text]');
        for (i = 0; i < countdownTextEls.length; i++) {
            countdownTextEls[i].innerHTML = countdownTemplate.replace('%d', countdownValue + "");
        }
    }

    function redirect() {
        clearInterval(autoRedirectInterval);
        window.location.href = url;
    }

    CleverReach.AutoRedirect = {
        start: start
    };
})();