<?php
/**
 * 2018 Cobiro.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    RST-IT
 * @copyright Cobiro 2018
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once _PS_MODULE_DIR_ . 'cobiro/cobiro/helpers/CobiroTools.php';
require_once _PS_MODULE_DIR_ . 'cobiro/cobiro/services/RepositoryService.php';
require_once _PS_MODULE_DIR_ . 'cobiro/cobiro/services/InitService.php';
require_once _PS_MODULE_DIR_ . 'cobiro/classes/WebserviceSpecificManagementCobiro.php';

/**
 * Class Cobiro.
 */
class Cobiro extends Module
{
    const NAME = 'cobiro';

    const ADMIN_CONTROLLER = 'AdminCobiro';

    const API_BIND = 'https://customer.cobiro.com/user/bind';

    /**
     * Options.
     */
    const OPT_GMC = 'COBIRO_GMC';
    const OPT_GCV_ID = 'COBIRO_GCV_ID';
    const OPT_GCV_LABEL = 'COBIRO_GCV_LABEL';

    /** @var InitService */
    private $initService;

    /** @var string[] */
    public $ps_versions_compliancy = array(
        'min' => '1.5',
        'max' => _PS_VERSION_,
    );

    /** @var string */
    public $module_key = '72a49ae80cd820c261cf40bee3044da3';

    /**
     * Cobiro constructor.
     */
    public function __construct()
    {
        /*
         * Keep the properties aligned with the class constants!
         * This is unfortunately required for the PrestaShop validator.
         */
        $this->name = 'cobiro';
        $this->tab = 'advertising_marketing';
        $this->version = '1.4.0';
        $this->author = 'Cobiro';
        $this->need_instance = 0;
        $this->meta_title = $this->l('Cobiro for PrestaShop');
        $this->subtitle = $this->l('Automated Google Ads');
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Cobiro');
        $this->description = $this->l('Cobiro for PrestaShop - Automated Google Ads');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall Cobiro for PrestaShop?');

        $this->initService = new InitService($this);
    }

    /**
     * @throws PrestaShopException
     *
     * @return bool
     */
    public function install()
    {
        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install() && $this->initService->install();
    }

    /**
     * @return bool
     */
    public function uninstall()
    {
        return $this->initService->uninstall() && parent::uninstall();
    }

    /**
     * Add custom JS file to page.
     */
    public function hookActionAdminControllerSetMedia()
    {
        $this->context->controller->addCSS($this->_path . 'views/css/cobiro.css');
    }

    /**
     * @param $params
     *
     * @throws PrestaShopException
     */
    public function hookDisplayOrderConfirmation($params)
    {
        $order = $params['objOrder'];
        if (version_compare(_PS_VERSION_, '1.7', '>=')) {
            $order = $params['order'];
        }

        $gcv_id = Configuration::get(self::OPT_GCV_ID);
        $gcv_label = Configuration::get(self::OPT_GCV_LABEL);
        $total_price = $order->total_paid;
        $currency = new Currency($order->id_currency);
        $order_id = $order->id;

        if ($gcv_id && $gcv_label && $currency && $order_id) {
            $this->context->smarty->assign(array(
                'cobiro_GoogleConversionID'    => $gcv_id,
                'cobiro_GoogleConversionLabel' => $gcv_label,
                'cobiro_TotalPrice'            => $total_price,
                'cobiro_Currency'              => $currency->iso_code,
                'orderId'                      => $order_id
            ));

            return $this->display(__FILE__, 'script-tag.tpl');
        }
    }

    /**
     * Display meta tags at frontend page head section.
     *
     * @param mixed $params
     *
     * @throws \Exception
     */
    public function hookDisplayHeader($params)
    {
        $gmc = Configuration::get(self::OPT_GMC);
        $gcv_id = Configuration::get(self::OPT_GCV_ID);
        if ($gmc || $gcv_id) {
            $this->context->smarty->assign(
                array(
                    'cobiro_gmc'                => $gmc,
                    'cobiro_GoogleConversionID' => $gcv_id
                )
            );

            return $this->display(__FILE__, 'gmc.tpl');
        }
    }

    /**
     * Configuration page.
     */
    public function getContent()
    {
        $token = Tools::getAdminTokenLite('AdminCobiro');
        $url = "index.php?controller=AdminCobiro&token={$token}";
        Tools::redirectAdmin($url);
    }
}
