<?php
/**
 * 2018 Cobiro.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    RST-IT
 * @copyright Cobiro 2018
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * Class CobiroTools with some helper functions.
 */
class CobiroTools
{
    public static function prepareShopArray()
    {
        return array(
            'shop_api_key' => RepositoryService::instance()->getApiKey(),
            'shop_id'      => (int) Context::getContext()->shop->id,
            'shop_url'     => self::getBaseUrl(),
            'shop_type'    => 'prestashop',
            'shop_name'    => Context::getContext()->shop->name,
            'currency'     => (string) Context::getContext()->currency->iso_code,
        );
    }

    /**
     * Returns the base url for given shop.
     *
     * @return string the base url.
     */
    public static function getBaseUrl()
    {
        $ssl = Configuration::get('PS_SSL_ENABLED');
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            return $ssl ? _PS_BASE_URL_SSL_ : _PS_BASE_URL_;
        }

        /** @var Shop|ShopCore $shop */
        $shop = Context::getContext()->shop;

        $base = $ssl ? 'https://' . $shop->domain_ssl : 'http://' . $shop->domain;

        return $base . $shop->getBaseURI();
    }
}
