<?php
/**
 * 2018 Cobiro.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    RST-IT
 * @copyright Cobiro 2018
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * Class AdminCobiroController.
 */
class AdminCobiroController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->action = 'view';
        $this->display = 'view';
        $this->defaultAction = 'view';
        $this->template = 'view.tpl';
        $this->meta_title = $this->l('Cobiro');
        $this->toolbar_title = $this->l('Cobiro');
        $this->lang = true;
        $this->context = Context::getContext();
        $this->bootstrap = true;
        $this->module = Module::getInstanceByName(Cobiro::NAME);
        $this->meta_title = $this->l('Cobiro for PrestaShop');
        $this->lite_display = false;
        $this->show_page_header_toolbar = true;
    }

    public function processView()
    {
        $shopArray = CobiroTools::prepareShopArray();
        $shopInfo = http_build_query($shopArray);
        $this->context->smarty->assign(array(
            'route_cobiro' => Cobiro::API_BIND . '?' . $shopInfo,
            'name' => $shopArray['shop_name'],
        ));
    }
}
