<?php

/*
 * This file is part of the API Platform project.
 *
 * (c) Kévin Dunglas <dunglas@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace ApiPlatform\Core\Operation\Factory;

/**
 * Computes subresource operation for a given resource.
 *
 * @author Antoine Bluchet <soyuka@gmail.com>
 */
interface SubresourceOperationFactoryInterface
{
    /**
     * Creates subresource operations.
     */
    public function create(string $resourceClass): array;
}
